// --- Lógica de Sesión ---
const creditCounter = document.getElementById('creditCounterDisplay');
const userSessionElement = document.getElementById('user-session');

function updateCreditCounter(amount) {
    if (creditCounter) { creditCounter.textContent = `Créditos: ${amount}`; creditCounter.style.display = 'block'; }
}
function checkLoginStatus() {
    fetch('check_session.php', { cache: 'no-store' })
        .then(r => r.json()).then(d => {
            if (d.loggedIn) {
                userSessionElement.innerHTML = `Bienvenido, <strong>${d.nombre}</strong> | <a href="index.html">Inicio</a> | <a href="logout.php">Salir</a>`;
                updateCreditCounter(d.creditos);
            } else { alert('Inicia sesión'); window.location.href = 'index.html'; }
        }).catch(e => console.error(e));
}
checkLoginStatus();

// --- Lógica de Generador IA ---
document.addEventListener('DOMContentLoaded', () => {
    const iaPromptInput = document.getElementById('iaPrompt');
    const iaStyleSelector = document.getElementById('iaStyleSelector');
    const generateIaImageBtn = document.getElementById('generateIaImageBtn');
    const iaGeneratedImage = document.getElementById('iaGeneratedImage');
    const loadingSpinner = document.getElementById('loadingSpinner');
    const downloadOriginalBtn = document.getElementById('downloadOriginalBtn');
    
    // Elementos del Molde
    const moldCanvas = document.getElementById('moldCanvas');
    const moldCtx = moldCanvas.getContext('2d');
    const generateMoldBtn = document.getElementById('generateMoldBtn');
    const downloadMoldPdfBtn = document.getElementById('downloadMoldPdfBtn');
    const statusDiv = document.getElementById('status');

    let currentGeneratedImageUrl = null;
    let currentImage = new Image(); 
    currentImage.crossOrigin = "Anonymous"; 
    let currentPromptText = ""; // Guardamos el prompt original del usuario

    // --- Construcción del Prompt (¡OPTIMIZADO PARA LINEART!) ---
    function buildPrompt(userText, style, isForLineartConversion = false) {
        const qualityBoost = "masterpiece, best quality, ultra detailed, 8k resolution, sharp focus";
        let stylePrompt = "";
        
        if (isForLineartConversion || style === 'lineart') {
            // Este es el prompt agresivo para lineart puro
            stylePrompt = "clean line art, black and white outline, coloring book page, no shadows, thick lines, simple shapes, white background, for printing, illustration, highly detailed, professional, sharp";
        } else {
            // Prompts para otros estilos de imagen a color
            switch(style) {
                case '3d': stylePrompt = "3d render, c4d, blender style, cute, volumetric lighting, soft shadows, vibrant colors, isolated on white background"; break;
                case 'sticker': stylePrompt = "sticker style, die-cut, vector illustration, white border, flat color, simple shading, isolated on white background"; break;
                case 'realistic': stylePrompt = "professional photography, studio lighting, realistic texture, cinematic, isolated on white background"; break;
            }
        }

        return `${userText}, ${stylePrompt}, ${qualityBoost}`; 
    }

    // --- Llamada a la API ---
    async function callAIGenerationAPI(userPrompt, style, isForLineartConversion = false) {
        statusDiv.textContent = `Generando imagen con IA... (10-15 seg - ${isForLineartConversion ? '2do crédito' : '1er crédito'})`;
        generateIaImageBtn.disabled = true;
        generateMoldBtn.disabled = true; // Desactivar también el botón de molde
        iaGeneratedImage.style.display = "none";
        loadingSpinner.style.display = "block";

        const finalPrompt = buildPrompt(userPrompt, style, isForLineartConversion);
        const seed = Math.floor(Math.random() * 1000000000); 
        
        const imageUrl = `https://image.pollinations.ai/prompt/${encodeURIComponent(finalPrompt)}?width=1280&height=1280&seed=${seed}&nologo=true&model=flux&enhance=true`;

        return imageUrl;
    }

    // --- Evento: Generar Imagen IA (Inicial) ---
    generateIaImageBtn.addEventListener('click', async () => {
        const prompt = iaPromptInput.value.trim();
        const style = iaStyleSelector.value;

        if (!prompt) { alert("Por favor describe qué quieres crear."); return; }
        currentPromptText = prompt; // Guardar el prompt original

        const resultUrl = await callAIGenerationAPI(prompt, style, false); // No es conversión a lineart inicial

        if (resultUrl) {
            currentGeneratedImageUrl = resultUrl;
            
            currentImage.onload = () => {
                iaGeneratedImage.src = currentGeneratedImageUrl;
                iaGeneratedImage.style.display = "block";
                loadingSpinner.style.display = "none";
                statusDiv.textContent = "¡Imagen HD lista! Si te gusta, descárgala o conviértela en dibujo para colorear.";
                
                downloadOriginalBtn.style.display = 'inline-block';
                // Si el estilo es 'lineart', ya tenemos el molde, no ofrecemos la opción de 'convertir'
                if (style === 'lineart') {
                    generateMoldBtn.style.display = 'none'; 
                    downloadMoldPdfBtn.style.display = 'inline-block';
                    // Mostrar la imagen directamente en el canvas de molde
                    moldCanvas.width = currentImage.width;
                    moldCanvas.height = currentImage.height;
                    moldCtx.drawImage(currentImage, 0, 0); 
                    statusDiv.textContent = "Dibujo para colorear generado directamente por IA. ¡Listo para PDF!";
                } else {
                    generateMoldBtn.style.display = 'inline-block'; // Mostrar botón para convertir
                    downloadMoldPdfBtn.style.display = 'none';
                    moldCtx.clearRect(0,0, moldCanvas.width, moldCanvas.height); // Limpiar molde si no es lineart
                }
                
                generateIaImageBtn.disabled = false;
                generateMoldBtn.disabled = false; // Habilitar si es aplicable
            };

            currentImage.onerror = () => {
                statusDiv.textContent = "El servidor de IA está saturado. Intenta de nuevo en 5 segundos.";
                loadingSpinner.style.display = "none";
                generateIaImageBtn.disabled = false;
                generateMoldBtn.disabled = false;
            };

            currentImage.src = resultUrl;
        }
    });

    // --- Evento: Descargar Imagen Original ---
    downloadOriginalBtn.addEventListener('click', async () => {
        if (currentGeneratedImageUrl) {
            try {
                const response = await fetch(currentGeneratedImageUrl);
                const blob = await response.blob();
                const url = window.URL.createObjectURL(blob);
                const link = document.createElement('a');
                link.href = url;
                link.download = `ia_hd_${Date.now()}.jpg`;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
            } catch (e) {
                window.open(currentGeneratedImageUrl, '_blank');
            }
        }
    });

    // --- Evento: Convertir a Molde (NUEVA GENERACIÓN DE IA para Lineart) ---
    generateMoldBtn.addEventListener('click', async () => {
        if (!currentPromptText) {
            alert("Primero debes generar una imagen principal.");
            return;
        }

        // Aquí hacemos la nueva llamada a la IA para el lineart
        const resultUrl = await callAIGenerationAPI(currentPromptText, 'lineart', true); // TRUE para indicar que es para lineart

        if (resultUrl) {
            currentGeneratedImageUrl = resultUrl; // La imagen del molde se convierte en la nueva imagen principal
            
            // Cargar la nueva imagen de lineart en el canvas del molde
            currentImage.onload = () => {
                moldCanvas.width = currentImage.width;
                moldCanvas.height = currentImage.height;
                moldCtx.drawImage(currentImage, 0, 0);
                
                // También actualizar la imagen principal mostrada si queremos
                iaGeneratedImage.src = currentGeneratedImageUrl; 
                iaGeneratedImage.style.display = "block"; // Asegurarse que se vea
                
                loadingSpinner.style.display = "none";
                statusDiv.textContent = "¡Dibujo para colorear generado por IA! Listo para PDF.";
                
                generateMoldBtn.style.display = 'none'; // Ya no se necesita el botón de convertir
                downloadMoldPdfBtn.style.display = 'inline-block';
                generateIaImageBtn.disabled = false;
            };

            currentImage.onerror = () => {
                statusDiv.textContent = "Error al generar el lineart. Intenta de nuevo.";
                loadingSpinner.style.display = "none";
                generateIaImageBtn.disabled = false;
                generateMoldBtn.disabled = false;
            };

            currentImage.src = resultUrl;
        }
    });

    // --- Evento: Descargar Molde PDF ---
    downloadMoldPdfBtn.addEventListener('click', () => {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF();
        const imgData = moldCanvas.toDataURL('image/jpeg', 0.8);
        
        const pdfW = 210; 
        const pdfH = 297; 
        const imgProps = doc.getImageProperties(imgData);
        const ratio = Math.min((pdfW-20)/imgProps.width, (pdfH-20)/imgProps.height);
        const w = imgProps.width * ratio;
        const h = imgProps.height * ratio;

        doc.addImage(imgData, 'JPEG', (pdfW-w)/2, 10, w, h);
        doc.text("Dibujo para colorear IA - EspacioApp", 10, 280);
        doc.save("Dibujo_Para_Colorear_IA.pdf");
    });
});