<?php
require_once 'config.php';

$response = ['success' => false, 'proyectos' => []];

// Recibimos el término de búsqueda (si existe)
$busqueda = isset($_GET['q']) ? trim($_GET['q']) : '';

try {
    // Construimos la consulta base
    $sql = "
        SELECT 
            p.id, 
            p.nombre_proyecto, 
            p.url_miniatura, 
            p.ancho_cm, 
            p.alto_cm,
            u.nombre AS creador_nombre
        FROM proyectos AS p
        JOIN usuarios AS u ON p.user_id = u.id
        WHERE p.es_publico = 1
    ";

    $params = [];

    // Si hay búsqueda, agregamos el filtro LIKE
    if (!empty($busqueda)) {
        $sql .= " AND p.nombre_proyecto LIKE ?";
        $params[] = "%" . $busqueda . "%";
    }

    // Ordenamos y limitamos
    $sql .= " ORDER BY p.fecha_creacion DESC LIMIT 50";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    
    $proyectos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response['success'] = true;
    $response['proyectos'] = $proyectos;

} catch (PDOException $e) {
    $response['message'] = 'Error de base de datos.';
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>