<?php
session_start();
require_once 'config.php';

$response = [
    'loggedIn' => false,
    'nombre' => null,
    'creditos' => 0
];

if (isset($_SESSION['user_id'])) {
    try {
        $stmt = $pdo->prepare("SELECT nombre, creditos FROM usuarios WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            $response['loggedIn'] = true;
            $response['nombre'] = $user['nombre'];
            $response['creditos'] = $user['creditos'];
        } else {
            // Usuario no encontrado en BD, limpiar sesión
            session_unset();
            session_destroy();
        }

    } catch (PDOException $e) {
        // Manejar error de base de datos silenciosamente o loguear
        // Para depuración, podrías enviar el mensaje de error:
        // $response['error_db'] = $e->getMessage(); 
        error_log("Error en check_session.php: " . $e->getMessage());
    }
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>