document.addEventListener('DOMContentLoaded', () => {
    const galleryGrid = document.getElementById('gallery-grid');
    const loadingMessage = document.getElementById('gallery-loading-message');

    fetch('cargar_galeria.php', { cache: 'no-store' })
        .then(response => response.json())
        .then(data => {
            if (data.success && data.proyectos.length > 0) {
                loadingMessage.style.display = 'none'; // Ocultar "Cargando..."
                
                data.proyectos.forEach(proyecto => {
                    const proyectoCard = document.createElement('a');
                    proyectoCard.className = 'proyecto-card';
                    // Guardamos el ID del proyecto para cargarlo
                    proyectoCard.href = `poster.html?cargar_id=${proyecto.id}`;
                    
                    proyectoCard.innerHTML = `
                        <img src="${proyecto.url_miniatura}" alt="${proyecto.nombre_proyecto}">
                        <h3>${proyecto.nombre_proyecto}</h3>
                        <p>${proyecto.ancho_cm}cm x ${proyecto.alto_cm}cm</p>
                    `;
                    galleryGrid.appendChild(proyectoCard);
                });

            } else if (data.success && data.proyectos.length === 0) {
                loadingMessage.textContent = 'No tienes ningún proyecto guardado todavía.';
            } else {
                loadingMessage.textContent = 'Error al cargar tus proyectos.';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            loadingMessage.textContent = 'Error de conexión.';
        });
});