<?php
// generate_image_ai.php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *'); // Cuidado con esto en producción real, limita a tu dominio
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Carga el autoloader de Composer
require __DIR__ . '/vendor/autoload.php';

use Replicate\ReplicateClient;

// !!! CONFIGURA TU API TOKEN DE REPLICATE AQUI !!!
// Es mejor almacenarlo en variables de entorno o un archivo de config seguro.
$replicateApiToken = 'r8_TU_API_TOKEN_AQUI_XXXXX'; // Reemplaza con tu token real

if (!$replicateApiToken) {
    http_response_code(500);
    echo json_encode(['error' => 'API Token de Replicate no configurado.']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);
$prompt = $data['prompt'] ?? '';

if (empty($prompt)) {
    http_response_code(400);
    echo json_encode(['error' => 'No se proporcionó un prompt.']);
    exit;
}

try {
    $replicate = new ReplicateClient($replicateApiToken);

    // Puedes elegir diferentes modelos. Este es un Stable Diffusion 1.5 común.
    // Revisa la librería de Replicate para más opciones y parámetros (tamaño, etc.)
    $output = $replicate->predictions()->create(
        model: 'stability-ai/sdxl', // O 'stability-ai/stable-diffusion:ac732df830a8c01fd6891beb2778390cf19267935ae0436ce583615e4e2be9ce',
        input: [
            'prompt' => $prompt,
            'width' => 512,  // Puedes ajustar el tamaño de la imagen generada
            'height' => 512, // para que sea más grande si necesitas más detalle para el molde.
            'num_outputs' => 1,
        ]
    );

    // Replicate devuelve una URL a la imagen
    $imageUrl = $output->output[0] ?? null;

    if ($imageUrl) {
        echo json_encode(['imageUrl' => $imageUrl]);
    } else {
        http_response_code(500);
        echo json_encode(['error' => 'No se pudo obtener la URL de la imagen generada.', 'replicate_output' => $output]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error al interactuar con la API de Replicate: ' . $e->getMessage()]);
}
?>