<?php
session_start();
require_once 'config.php';

$response = ['success' => false, 'message' => 'No autorizado.'];

// 1. Verificar que el usuario esté logueado y que se pidió un ID
if (!isset($_SESSION['user_id']) || !isset($_GET['id'])) {
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

$user_id = $_SESSION['user_id'];
$proyecto_id = (int)$_GET['id'];

try {
    // --- ¡LÓGICA CORREGIDA! ---
    // Ahora comprobamos si el proyecto tiene el ID correcto Y
    // (es del usuario actual O es público)
    $stmt = $pdo->prepare("
        SELECT * FROM proyectos 
        WHERE id = ? AND (user_id = ? OR es_publico = 1)
    ");
    $stmt->execute([$proyecto_id, $user_id]);
    $proyecto = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($proyecto) {
        // ¡Éxito! El proyecto se encontró y es accesible
        $response['success'] = true;
        $response['proyecto'] = $proyecto;
    } else {
        // Si no se encuentra nada, AHORA SÍ es un error
        $response['message'] = 'Proyecto no encontrado o es privado.';
    }

} catch (PDOException $e) {
    $response['message'] = 'Error de base de datos: ' . $e->getMessage();
}

header('Content-Type: application/json');
echo json_encode($response);
exit();
?>